from axelrod.action import Action, actions_to_str

from axelrod.player import Player

from axelrod.strategy_transformers import (
    FinalTransformer,
    TrackHistoryTransformer,
)

C, D = Action.C, Action.D

class TitFor2Tats(Player):
    """A player starts by cooperating and then defects only after two defects by
    opponent.

    Submitted to Axelrod's second tournament by John Maynard Smith; it came in
    24th in that tournament.

    Names:

    - Tit for two Tats: [Axelrod1984]_
    - Slow tit for two tats: Original name by Ranjini Das
    - JMaynardSmith: [Axelrod1980b]_
    """

    name = "Tit For 2 Tats"
    classifier = {
        "memory_depth": 2,  # Long memory, memory-2
        "stochastic": False,
        "long_run_time": False,
        "inspects_source": False,
        "manipulates_source": False,
        "manipulates_state": False,
    }

    @staticmethod
    def strategy(opponent: Player) -> Action:
        """Actual strategy definition that determines player's action."""
        return D if opponent.history[-2:] == [D, D] else C